// ticks is the number of nodes the algorithm with look at this frame
var ticks = algSteps;

while (ticks && (openList.notEmpty())) {
  ticks--;
  o = openList.pop();
  if (o.point.x == end.x) {
    if (o.point.y == end.y) {
      trace("done!");
      openList = null;
      drawPath(o);
      return;
    }
  }
  // trace("current:" + o.point.x + ":" + o.point.y);
  l = myGrid.getNeighbors(o.point);
  var ll = l.length;
  for (var i = 0; i < ll; i++) {
    var n = l[i];
    var fromStart = o.g + 1 + n.travelCost;
    if (myGrid.isClosed(n.point)) {
      // trace("  closed: " + fromStart + " : " + n.g);
      continue;
    }
    
    if (n.parent) {// has this node been looked at?  
      if (n.g <= fromStart) {
        continue;
      }
    }
    
    /*
    if (n.closed) {
      n.closed = false;
      trace("opening");
      myGrid.setOpen(n.point);
    }
    */
    // set the estimate (h) distance:     
    n.distance(end);
    
    // set g and then set f = g + h:
    var fullPath = n.setShortPathTo(o, fromStart);
    // okay, this is the better path... 

    openList.removeItem(n);
    openList.addItem(n);
     
  }
  myGrid.setClosed(o.point);

}

if (! openList.notEmpty()) {
  trace("Open list is empty");
  stop();
}

