// astar.as

function NodeBank () {
  this.nodes = new Array();
  this.bank = new Array();
  this.nodesPerAllocation = 50;
  
  this.increaseNodes();
}

NodeBank.prototype.increaseNodes = function() {
  for (var i = 0; i < this.nodesPerAllocation; i++) {
    var a = new PathNode();
    this.nodes.push(a);
    this.bank.push(a);
  }
  trace("Allocated " + i + " new nodes.");  
}

NodeBank.prototype.fetchNode = function() {
  if (this.bank.length < 1) {
    this.increaseNodes();
  }
  
  var n = this.bank.pop();
  n.parent = null;
  n.g = null
  n.h = null;
  n.f = null;
  n.closed = false;
  n.travelCost = 0;
  return n;
}

NodeBank.prototype.reset = function() {
  this.bank = new Array();
  var l = this.nodes.length;
  for (var i = 0; i < l; i++) {
    this.bank.push(this.nodes[i]);
  }
  trace("resetting");
}

function PathNode() {
  this.parent = null;
  this.g = null
  this.h = null;
  this.f = null;
  this.closed = false;
  this.travelCost = 0;
  this.point = null
}

var euclidean = false;
if (euclidean) {
  PathNode.prototype.distance = function(p) {
    if (this.h == null) {
      // Euclidean distance:
      var c = (this.point.x - p.x) * (this.point.x - p.x);
      c += (this.point.y - p.y) * (this.point.y - p.y);
      this.h = Math.sqrt(c);
    /*
      // orthogonal distance:
      this.h = Math.abs(this.point.x - p.x) + Math.abs(this.point.y - p.y);
    */
      
    }
    return this.h;
  }
} else {
  PathNode.prototype.distance = function(p) {
    if (this.h == null) {
    /*
      // Euclidean distance:
      var c = (this.point.x - p.x) * (this.point.x - p.x);
      c += (this.point.y - p.y) * (this.point.y - p.y);
      this.h = Math.sqrt(c);
    */
      // orthogonal distance:
      this.h = 1 * Math.abs(this.point.x - p.x) + Math.abs(this.point.y - p.y);
      
    }
    return this.h;
  }

}

PathNode.prototype.setShortPathTo = function(n, dist) {
  this.parent = n;
  this.g = dist;
  this.f = this.g + this.h;
  return this.f;
}

function Grid(x, y) {
  var s = x * y;
  this.height = y;
  this.width = x;
  // this.list = new Array(s);

  // _root.createEmptyMovieClip("dots", 5);
  this.board = _root.drawing;
  this.stuff = new Array();
}

Grid.prototype.clearStuff = function() {
  this.stuff = new Array();
}

Grid.prototype.reset = function() {
  this.board.clear();
  
  for (var i = 0; i < gridXSize; i++) {
    for (var j = 0; j < gridYSize; j++) {
      this["bx" + i + "y" + j] = false;
      this["x" + i + "y" + j] = null;
    }
  }
  
  var sl = this.stuff.length;
  var ns = this.stuff;
  this.stuff = new Array();
  for (var i = 0; i < sl; i++) {
    var s = ns[i];
    switch (s.type) {
      case "wall": 
        this.setBlocked(s.p);
        break;
      case "trees":
        this.setWoody(s.p);    
        break;
      case "swamp":
        this.setSwampy(s.p);
        break;
    }
  }
}

Grid.prototype.setSwampy = function(p) {
  if (this.isBlocked(p)) {
    this["bx" + p.x + "y" + p.y] = false;
  }
  var n = this.getNodeAt(p);
  n.travelCost = 2;
  this.drawHit(p, nodeSize, 0x9999ff);
  
  this.stuff.push({type: "swamp", p: p});
}

Grid.prototype.setWoody = function(p) {
  if (this.isBlocked(p)) {
    this["bx" + p.x + "y" + p.y] = false;
  }
  var n = this.getNodeAt(p);
  n.travelCost = .5;
  this.drawHit(p, nodeSize, 0x99ff99);

  this.stuff.push({type: "trees", p: p});
}


Grid.prototype.setClosed = function(p) {
  var n = this.getNodeAt(p);
  n.closed = true;
  this.drawHit(p, (nodeSize / 2) - 1, 0x999999);
}

Grid.prototype.setOpen = function(p) {
  this.drawHit(p, (nodeSize / 2) - 1, 0x00ff00);
}

Grid.prototype.setBlocked = function(p) {
  var c = "bx" + p.x + "y" + p.y;
  this[c] = true;
  this.drawHit(p, nodeSize, 0x333333);
  this.stuff.push({type: "wall", p: p});
}

Grid.prototype.isBlocked = function(p) {
  var c = "bx" + p.x + "y" + p.y;
  return this[c] ? true : false;
}

Grid.prototype.isClosed = function(p) {
  var c = "x" + p.x + "y" + p.y;
  return this[c] ? this[c].closed : false;
}

Grid.prototype.getNodeAt = function(p) {
  var c = "x" + p.x + "y" + p.y;
  // var c = this.width * p.y + p.x;
  if (this.isBlocked(p)) {
    return null;
  }
  if (this[c]) {
    if (!this[c].closed) this.drawHit(p, (nodeSize / 2) - 1, 0xffffff);
    return this[c];
  } else {
    var n = bank.fetchNode();
    n.point = p;
    this[c] = n;
    
    this.drawHit(p, (nodeSize / 2) - 1, 0xffffff);
    // trace("new node at " + p.x  + " :" + p.y);
    return n;
  }
}

Grid.prototype.drawHit = function(p, w, fill) {
  var x = p.x * nodeSize;
  var y = p.y * nodeSize;
  var off = (nodeSize - w) / 2;
  // trace("drawing " + x + "," + y);
  this.board.drawBox(off + x, off + y, w, w, fill, fill);
  
}

Grid.prototype.getNeighbors = function(p) {
  var l = new Array();
  var n;
  if (p.x > 0) {
    n = this.getNodeAt(new Point(p.x - 1, p.y));
    if (n) {
      l.push(n);
    }
  }
  if (p.x < this.width - 1) {
    n = this.getNodeAt(new Point(p.x + 1, p.y));
    if (n) {
      l.push(n);
    }
  }
  if (p.y > 0) {
    n = this.getNodeAt(new Point(p.x, p.y - 1));
    if (n) {
      l.push(n);
    }
  }
  if (p.y < this.height - 1) {
    n = this.getNodeAt(new Point(p.x, p.y + 1));
    if (n) {
      l.push(n);
    }
  }
  
  return l;
}

function Point(x, y) {
  this.x = x;
  this.y = y;
}

function DumbList() {
  this.list = new Array();
}

DumbList.prototype.addItem = function(n) {
  var ooo = new Array();
  var l = this.list.length;
  var unpushed = true;
  for (var j = 0; j < l; j++) {
    var e = this.list[j];
    if (unpushed) {
      if (e.f < n.f) {
        ooo.push(n);
        unpushed = false;
      }
    }
    if (e <> n) {
      // trace(e.f);
      ooo.push(e);
    }
  }
  if (unpushed) {
  // trace("    shortest (" + fullPath + ")");
    ooo.push(n);
  }
  this.list = ooo;
}

DumbList.prototype.removeItem = function(n) {}

DumbList.prototype.notEmpty = function() {
  return this.list.length ? true : false;
}

DumbList.prototype.pop = function() {
  return this.list.pop();
}

#include "linkedlist.as"

function bestGuessDistance(p1, p2) {
  var c = (p1.x - p2.x) * (p1.x - p2.x);
  c += (p1.y - p2.y) * (p1.y - p2.y);
  return Math.sqrt(c);
}

function drawPath(n) {
  while (n.parent) {
    myGrid.drawHit(n.point,  (nodeSize / 2) + 1, 0x00ff00);
    n = n.parent;  
  }
}

function stopIt() {
  _root.startX._visible = true;
  _root.endX._visible = true;
  
  stop();
  _root.stopButton._visible = false;
  _root.findButton._visible = false;
}

function resetStuff() {
  _root.startX._visible = true;
  _root.endX._visible = true;
  
  stop();

  bank.reset();

  myGrid.reset();
  
  openList = new LinkedList();

  _root.stopButton._visible = false;
  _root.findButton._visible = true;
}

function startIt() {
  var steps = Math.floor(new Number(algSteps));
  algSteps = (steps > 0) ? steps : 20;
  
  _root.startX._visible = false;
  _root.endX._visible = false;

  start = new Point(Math.floor(_root.startX._x / nodeSize),
    Math.floor(_root.startX._y / nodeSize));
  end = new Point(Math.floor(_root.endX._x / nodeSize), 
    Math.floor(_root.endX._y / nodeSize));

  myGrid.drawHit(start, nodeSize, 0x33ff33);
  myGrid.drawHit(end, nodeSize, 0xff3333);

  var p = myGrid.getNodeAt(start);

  openList.addItem(p);
  _root.stopButton._visible = true;
  _root.findButton._visible = false;

}

function clearStuff() {
  myGrid.clearStuff();
  resetStuff();
}

function doClick(type) {
  if (type <> "wall") {
    _root.wall.gotoAndStop(1);
  }
  if (type <> "trees") {
    _root.trees.gotoAndStop(1);
  }
  if (type <> "swamp") {
    _root.swamp.gotoAndStop(1);
  }
  
  drawType = type;
}

function doDrawMouse() {
  var x = Math.floor(_xmouse / nodeSize);
  var y = Math.floor(_ymouse / nodeSize);
  var p = new Point(x, y);
  switch (drawType) {
    case "wall": 
      myGrid.setBlocked(p);
      break;
    case "trees":
      myGrid.setWoody(p);    
      break;
    case "swamp":
      myGrid.setSwampy(p);
      break;
  }
}

bank = new NodeBank();
// closed = new ClosedList();

resetStuff();

algSteps = 20;

var nodeSize = 10;
var gridXSize = 300 / nodeSize;
var gridYSize = 240 / nodeSize;

myGrid = new Grid(gridXSize, gridYSize);

for (var i = 0; i < gridXSize; i++) {
  for (var j = 0; j < gridYSize; j++) {
    /*
    if (_root.swamps.hitTest(10 * i + 5, 10 * j + 5, true)) {
      myGrid.setSwampy(new Point(i, j));
    }
    if (_root.woods.hitTest(10 * i + 5, 10 * j + 5, true)) {
      myGrid.setWoody(new Point(i, j));
    }
    */
    if (_root.obstacles.hitTest(nodeSize * (i + .5), nodeSize * (j + .5), true)) {
      myGrid.setBlocked(new Point(i, j));
    }
  }
}


_root.obstacles._visible = false;
_root.swamps._visible = false;
_root.woods._visible = false;

_root.stopButton._visible = false;

stop();




