
function LinkedList() {
  // A linked list (not the most efficient, but
  // better than an Array for keeping nodes sorted)
  this.head = null;
}

LinkedList.prototype.addItem = function(n) {
  var place = this.head;

  if (! this.notEmpty()) {
    this.head = {node:n};
    return;
  }

  if (n.f <= this.head.node.f) {
    this.head = {node:n, next:this.head};
    return;
  }

  while (place.next) {
    if (n.f > place.next.node.f) {
      place = place.next;
    } else {
      // insert into the list:
      var item = {node:n, next:place.next};
      place.next = item;
      return;
    }
  }
  place.next = {node:n};
}

LinkedList.prototype.removeItem = function(n) {
  while (this.head == n) {
    this.head = this.head.next;
  }
  
  var place = this.head;
  var next = place.next;
  while(next) {
    if (place.node <> n) {
      place = next;
      next = place.next;
    } else {
      place.node = next.node;
      place.next = next.next;
      place = place.next;
      next = place.next;
    }
  }
  //  this.addItem(n);
}

LinkedList.prototype.notEmpty = function() {
  return this.head ? true : false;
}

LinkedList.prototype.pop = function() {
  var p = this.head;
  this.head = p.next; // might be null
  return p.node;
}

/*
var ll = new LinkedList();
var ff = {f: 10};
ll.addItem(ff);
ll.addItem({f: 4});
ll.removeItem(ff);
trace(ll.pop().node.f);
*/
